import dataclasses
import typing

from infra.walle.server.proto.walle.scenario.data_storage.v1 import scenario_data_storage_pb2
from walle.scenario.host_groups_builders.base import BaseHostGroupSource


@dataclasses.dataclass(frozen=True)
class MaintenanceApproversGroup:
    group_id: int
    name: str
    logins: typing.List[str] = dataclasses.field(default_factory=list)

    def to_protobuf(self) -> scenario_data_storage_pb2.ItdcMaintenanceApproversGroup:
        proto_result = scenario_data_storage_pb2.ItdcMaintenanceApproversGroup()
        proto_result.group_id = self.group_id
        proto_result.name = self.name
        proto_result.logins.extend(self.logins)
        return proto_result


@dataclasses.dataclass
class ApprovementDecision:
    skip_approvement: bool = False
    reason: str = None

    def to_dict(self):
        return {"skip_approvement": self.skip_approvement, "reason": self.reason}

    @classmethod
    def from_dict(cls, data: dict):
        return ApprovementDecision(
            skip_approvement=data.get("skip_approvement", False), reason=data.get("reason", None)
        )


@dataclasses.dataclass
class HostGroupSource:
    group_id: int
    source: BaseHostGroupSource = None
    approvement_decision: ApprovementDecision = None

    def to_dict(self):
        return {
            "group_id": self.group_id,
            "source": self.source.to_dict(),
            "approvement_decision": self.approvement_decision.to_dict() if self.approvement_decision else {},
        }

    @classmethod
    def from_dict(cls, data: dict):
        return HostGroupSource(
            group_id=data["group_id"],
            source=BaseHostGroupSource.from_dict(data["source"]),
            approvement_decision=ApprovementDecision.from_dict(data.get("approvement_decision", {})),
        )
