import dataclasses
import typing

import attr

from walle.maintenance_plot.scenarios_settings.base import BaseScenarioMaintenancePlotSettings
from walle.scenario.constants import ScriptName
from walle.scenario.data_storage.base import BaseScenarioDataStorage
from walle.scenario.errors import ScenarioDoesNotHaveDefinition
from walle.scenario.scenario import Scenario

ALL_SCENARIOS_DEFINITIONS = []


@dataclasses.dataclass(frozen=True)
class BaseScenarioDefinition:
    script_name: str = None
    data_storage: typing.Type[BaseScenarioDataStorage] = None
    scenario_parameters: attr = None
    maintenance_plot_settings: typing.Type[BaseScenarioMaintenancePlotSettings] = None

    on_scenario_creation_checks: typing.List[typing.Callable] = dataclasses.field(default_factory=list)


def get_scenario_definition(script_name: typing.Literal[tuple(ScriptName.ALL_EXISTING)]):
    for scenario_type in ALL_SCENARIOS_DEFINITIONS:
        if scenario_type.script_name == script_name:
            return scenario_type
    raise ScenarioDoesNotHaveDefinition("No definition found for scenario '%s'" % script_name)


def get_data_storage(scenario: Scenario) -> BaseScenarioDataStorage:
    klass = get_scenario_definition(scenario.scenario_type)
    return klass.data_storage(scenario.data_storage)
