import dataclasses

from walle.maintenance_plot.scenarios_settings.hosts_transfer import HostsTransferMaintenancePlotSettings
from walle.maintenance_plot.scenarios_settings.itdc_maintenance import ItdcMaintenanceMaintenancePlotSettings
from walle.maintenance_plot.scenarios_settings.noc_hard import NocHardMaintenancePlotSettings
from walle.maintenance_plot.scenarios_settings.noc_soft import NocSoftMaintenancePlotSettings
from walle.scenario.constants import ScriptName
from walle.scenario.data_storage.data_storage import (
    ItdcMaintenanceDataStorage,
    NocHardDataStorage,
    NocSoftDataStorage,
    HostsTransferDataStorage,
    YTMaintenanceDataStorage,
)
from walle.scenario.definitions.base import ALL_SCENARIOS_DEFINITIONS, BaseScenarioDefinition
from walle.scenario.maintenance_plot_checks import check_if_maintenance_start_time_is_too_soon
from walle.scenario.script_args import (
    ItdcMaintenanceParams,
    NocHardParams,
    NocSoftParams,
    HostsTransferParams,
    EmptyParams,
)


@dataclasses.dataclass(frozen=True)
class ItdcMaintenanceScenarioDefinition(BaseScenarioDefinition):
    script_name = ScriptName.ITDC_MAINTENANCE
    data_storage = ItdcMaintenanceDataStorage
    scenario_parameters = ItdcMaintenanceParams
    maintenance_plot_settings = ItdcMaintenanceMaintenancePlotSettings

    on_scenario_creation_checks = [check_if_maintenance_start_time_is_too_soon]


@dataclasses.dataclass(frozen=True)
class NocHardScenarioDefinition(BaseScenarioDefinition):
    script_name = ScriptName.NOC_HARD
    data_storage = NocHardDataStorage
    scenario_parameters = NocHardParams
    maintenance_plot_settings = NocHardMaintenancePlotSettings

    on_scenario_creation_checks = [check_if_maintenance_start_time_is_too_soon]


@dataclasses.dataclass(frozen=True)
class SetMaintenanceWithGroupsApprovesScenarioDefinition(BaseScenarioDefinition):
    script_name = ScriptName.SET_MAINTENANCE_WITH_GROUPS_APPROVES
    data_storage = ItdcMaintenanceDataStorage
    scenario_parameters = ItdcMaintenanceParams
    maintenance_plot_settings = ItdcMaintenanceMaintenancePlotSettings

    on_scenario_creation_checks = []


@dataclasses.dataclass(frozen=True)
class NocSoftScenarioDefinition(BaseScenarioDefinition):
    script_name = ScriptName.NOC_SOFT
    data_storage = NocSoftDataStorage
    scenario_parameters = NocSoftParams
    maintenance_plot_settings = NocSoftMaintenancePlotSettings

    on_scenario_creation_checks = []


@dataclasses.dataclass(frozen=True)
class HostsTransferScenarioDefinition(BaseScenarioDefinition):
    script_name = ScriptName.HOSTS_TRANSFER
    data_storage = HostsTransferDataStorage
    scenario_parameters = HostsTransferParams
    maintenance_plot_settings = HostsTransferMaintenancePlotSettings

    on_scenario_creation_checks = []


@dataclasses.dataclass(frozen=True)
class YTMaintenanceScenarioDefinition(BaseScenarioDefinition):
    script_name = ScriptName.YT_MAINTENANCE
    data_storage = YTMaintenanceDataStorage
    scenario_parameters = EmptyParams

    on_scenario_creation_checks = []


ALL_SCENARIOS_DEFINITIONS.append(ItdcMaintenanceScenarioDefinition)
ALL_SCENARIOS_DEFINITIONS.append(NocHardScenarioDefinition)
ALL_SCENARIOS_DEFINITIONS.append(SetMaintenanceWithGroupsApprovesScenarioDefinition)
ALL_SCENARIOS_DEFINITIONS.append(NocSoftScenarioDefinition)
ALL_SCENARIOS_DEFINITIONS.append(HostsTransferScenarioDefinition)
ALL_SCENARIOS_DEFINITIONS.append(YTMaintenanceScenarioDefinition)
