from datetime import datetime

from sepelib.core.constants import MINUTE_SECONDS
from walle.errors import ResourceNotFoundError, ResourceConflictError, WalleError, BadRequestError

DEFAULT_ERROR_ADVANCE_PERIOD = MINUTE_SECONDS


class KeyDoesNotExistsRegistryError(ResourceNotFoundError):
    def __init__(self, registry, msg=None):
        super().__init__("{} doesn't have {}".format(registry.__name__, msg))


class KeyAlreadyExistsRegistryError(ResourceConflictError):
    def __init__(self, registry, msg=None):
        super().__init__("{} already have {}".format(registry.__name__, msg))


class IncorrectScriptError(Exception):
    def __init__(self, msg):
        self.msg = msg
        super().__init__(self)


class ScenarioValidationError(Exception):
    def __init__(self, error):
        self.error = error
        super().__init__(error)


class ScenarioNotFoundError(ResourceNotFoundError):
    def __init__(self):
        super().__init__("The specified scenario ID doesn't exist.")


class EmptySwitchForNocScenario(ResourceNotFoundError):
    def __init__(self, switch):
        super().__init__("There are no hosts associated with switch '{}'".format(switch))


class ActionDoesNotExist(Exception):
    def __init__(self, msg):
        self.message = msg
        super().__init__(self)


class CorrectYpSlaDoesNotExists(BadRequestError):
    def __init__(self, maintenance_start_time):
        date = datetime.fromtimestamp(maintenance_start_time).strftime("%Y-%m-%d")
        super().__init__("Correct starting time for YP does not exists for your date: {}".format(date))


class ErrorList(WalleError):
    def __init__(self, errors):
        self.errors = errors


class HostDoesNotHaveBotProjectIDError(WalleError):
    pass


class ScenarioDoesNotHaveDefinition(WalleError):
    pass
