import typing
from collections import defaultdict

from walle.scenario.host_groups_builders.base import HostGroup, MaintenancePlotHostGroupSource
from walle.scenario.host_groups_builders.hosts_properties_getter import ProjectProperties


def build_groups_by_maintenance_plot(
    hosts_project_properties_map: typing.Dict[int, ProjectProperties]
) -> (typing.List[HostGroup], typing.List[int]):
    maintenance_plot_id_to_hosts_invs_list_map = defaultdict(list)
    hosts_without_maintenance_plot = []

    for host_inv, project_properties in hosts_project_properties_map.items():
        if project_properties.maintenance_plot_id is None:
            hosts_without_maintenance_plot.append(host_inv)
            continue
        maintenance_plot_id_to_hosts_invs_list_map[project_properties.maintenance_plot_id].append(host_inv)

    return [
        HostGroup(
            group_source=MaintenancePlotHostGroupSource(maintenance_plot_id=maintenance_plot_id),
            hosts_invs=hosts_invs_list,
        )
        for maintenance_plot_id, hosts_invs_list in maintenance_plot_id_to_hosts_invs_list_map.items()
    ], hosts_without_maintenance_plot
