import typing
from collections import defaultdict

from walle.scenario.constants import HostGroupsBuildersSpecificProjectTags
from walle.scenario.host_groups_builders.base import HostGroup, SpecificProjectTagHostGroupSource
from walle.scenario.host_groups_builders.hosts_properties_getter import ProjectProperties

# WALLE-4081 Order of known tags matters.
SPECIFIC_PROJECT_TAGS_LIST = [
    HostGroupsBuildersSpecificProjectTags.YT_MASTERS_PROJECT_TAG,
    HostGroupsBuildersSpecificProjectTags.YT_PROJECT_TAG,
    HostGroupsBuildersSpecificProjectTags.YP_PROJECT_TAG,
    HostGroupsBuildersSpecificProjectTags.YABS_PROJECT_TAG,
]


def build_groups_by_specific_project_tag(
    hosts_project_properties_map: typing.Dict[int, ProjectProperties]
) -> (typing.List[HostGroup], typing.List[int]):
    specific_project_tag_to_hosts_invs_list_map = defaultdict(list)
    hosts_without_specific_project_tag = []

    for host_inv, project_properties in hosts_project_properties_map.items():

        matched_tag = None
        for tag in SPECIFIC_PROJECT_TAGS_LIST:
            if tag in hosts_project_properties_map[host_inv].tags:
                matched_tag = tag
                break

        if matched_tag:
            specific_project_tag_to_hosts_invs_list_map[matched_tag].append(host_inv)
        else:
            hosts_without_specific_project_tag.append(host_inv)

    return [
        HostGroup(
            group_source=SpecificProjectTagHostGroupSource(specific_project_tag=specific_project_tag),
            hosts_invs=hosts_invs_list,
        )
        for specific_project_tag, hosts_invs_list in specific_project_tag_to_hosts_invs_list_map.items()
    ], hosts_without_specific_project_tag
