from mongoengine import StringField, EmbeddedDocumentField, IntField, LongField

from sepelib.mongo.util import register_model
from walle.models import Document
from walle.scenario.stage_info import StageInfo


@register_model
class HostStageInfo(Document):
    host_uuid = StringField(primary_key=True, required=True)
    scenario_id = IntField(required=True, help_text="Scenario id that is currently in use on this host")
    stage_info = EmbeddedDocumentField(StageInfo, help_text="Information about host's status and stages in scenario")
    revision = LongField(default=0, help_text="Current stage info revision, defence against concurrent modifications")

    meta = {
        "indexes": [
            {"name": "scenario_id", "fields": ["scenario_id"], "unique": False},
            {"name": "uuid_and_scenario_id", "fields": ["host_uuid", "scenario_id"], "unique": True},
        ]
    }
