from walle.errors import ResourceConflictError
from walle.scenario.constants import WORK_STATUS_LABEL_NAME
from walle.util.text import enumeration_join


class InvalidMaintenanceStatusTransition(ResourceConflictError):
    def __init__(self, scenario, new_status, allowed_statuses):
        super().__init__(
            "'{}' status can only be assigned to works in '{}' statuses. Work #{} is in '{}' status.",
            new_status,
            enumeration_join(sorted(allowed_statuses), comma="', '", last="' and '"),
            scenario.scenario_id,
            scenario.labels.get(WORK_STATUS_LABEL_NAME),
        )


def check_status_transition(scenario, new_status, allowed_statuses):
    if scenario.labels.get(WORK_STATUS_LABEL_NAME) not in allowed_statuses:
        raise InvalidMaintenanceStatusTransition(scenario, new_status, allowed_statuses)
