from enum import Enum


class MarkerStatus(Enum):
    FAILURE = 0
    SUCCESS = 1
    IN_PROGRESS = 2


class Marker:
    def __init__(self, status, message="no message", data=None):
        self.status = status
        self.data = data
        self.message = message

    def __eq__(self, other):
        return self.status == other.status and self.data == other.data and self.message == other.message

    def __str__(self):
        return self.status.name

    def __repr__(self):
        return "<Marker(status={status}, message={message!r}, data={data!r})>".format(
            status=self.status.name, message=self.message, data=self.data
        )

    @classmethod
    def failure(cls, **kwargs):
        return cls(MarkerStatus.FAILURE, **kwargs)

    @classmethod
    def success(cls, **kwargs):
        return cls(MarkerStatus.SUCCESS, **kwargs)

    @classmethod
    def in_progress(cls, **kwargs):
        return cls(MarkerStatus.IN_PROGRESS, **kwargs)


def create_shared_data(shared_data_key, data):
    return {shared_data_key: data}


def unpack_shared_data(shared_data):
    return next(iter(shared_data.items()))
