from contextlib import contextmanager

from walle.scenario.stages import HostRootStage


class ScriptBuilder:
    def __init__(self):
        self._stages = []

    def add_stage(self, stage):
        self._stages.append(stage)

    def add_stages(self, stages):
        self._stages.extend(stages)

    def get_stages(self):
        return self._stages[:]

    @contextmanager
    def host_stages(self, scheduler, **scheduler_params):
        nested = ScriptBuilder()
        try:
            yield nested
        finally:
            self.add_stage(scheduler([HostRootStage(nested.get_stages())], **scheduler_params))
