from walle.scenario.constants import StageName, TemplatePath
from walle.scenario.stage.host_group_approve_stage import HostGroupApproveStage
from walle.scenario.stage_info import StageRegistry


@StageRegistry.register(StageName.NocHardHostGroupApproveStage)
class NocHardHostGroupApproveStage(HostGroupApproveStage):
    """Creates approvement in OK and tracks its resolution."""

    ok_approve_request_text_template_path = TemplatePath.OK_NOC_HARD_HOST_GROUP_APPROVE_REQUEST
    startrek_approvement_text_tempate_path = TemplatePath.STARTREK_NOC_HARD_HOST_GROUP_APPROVEMENT_TEXT
    startrek_escalation_text_template_path = TemplatePath.STARTREK_ITDC_MAINTENANCE_HOST_GROUP_APPROVE_ESCALATION
    startrek_received_approve_text_template_path = TemplatePath.STARTREK_NOC_HARD_HOST_GROUP_RECEIVED_APPROVE
    startrek_approve_rejected_text_template_path = TemplatePath.STARTREK_NOC_HARD_HOST_GROUP_APPROVE_REJECTED


@StageRegistry.register(StageName.ManualConfirmationHostGroupApproveStage)
class ManualConfirmationHostGroupApproveStage(HostGroupApproveStage):
    """Creates approvement in OK and tracks its resolution."""

    ok_approve_request_text_template_path = TemplatePath.COMMON_HOST_GROUP_APPROVE_REQUEST
    startrek_approvement_text_tempate_path = TemplatePath.COMMON_HOST_GROUP_APPROVEMENT_TEXT
    startrek_received_approve_text_template_path = TemplatePath.COMMON_HOST_GROUP_RECEIVED_APPROVE
    startrek_approve_rejected_text_template_path = TemplatePath.COMMON_HOST_GROUP_APPROVE_REJECTED
