from sepelib.core import config
from walle.operations_log.operations import get_last_operation
from walle.projects import Project, DEFAULT_CMS_NAME
from walle.scenario.errors import KeyDoesNotExistsRegistryError, KeyAlreadyExistsRegistryError


class BaseRegistry:

    ITEMS = {}

    @classmethod
    def register(cls, key):
        def decorator(function):
            if key in cls.ITEMS:
                raise KeyAlreadyExistsRegistryError(cls, key)

            cls.ITEMS[key] = function
            return function

        return decorator

    @classmethod
    def get(cls, key):
        if key in cls.ITEMS:
            return cls.ITEMS[key]
        raise KeyDoesNotExistsRegistryError(cls, key)

    @classmethod
    def get_keys(cls):
        return list(cls.ITEMS.keys())


def is_project_cms_allowed_for_noc_works(project_id, add_allowed_cms=None):
    project = Project.objects.get(id=project_id)
    if project.cms == DEFAULT_CMS_NAME:
        return False

    cms_name = project.get_cms_name()
    if add_allowed_cms and cms_name in add_allowed_cms:
        return True

    return cms_name in config.get_value("scenario.stages.prepare_for_work_stage.allowed_cms", [])


def check_last_operation_from_oplog(host, operation, scenario_id):
    last_operation = get_last_operation(host)
    if last_operation and last_operation["type"] == operation.type and last_operation["scenario_id"] == scenario_id:
        return True
    return False
