from sepelib.core import config, constants
from walle.constants import CronType

from walle.admin_requests.request import _gc_admin_requests
from walle.cauth import preheat_group_members_cache, check_certificate_date
from walle.cms import GC_ABANDONED_CMS_TASKS_WORK_TIME, _cms_gc, _gc_cms
from walle.cron.config_redefinition_monitoring import _start_config_monintoring
from walle.cron.dmc_shards_processing import _start_dmc_shards_processing
from walle.cron.infiniband_info_sync import _infiniband_info_sync
from walle.cron.tier_sync import _sync_tiers
from walle.cron.shadow_hosts_sync import _sync_shadow_hosts
from walle.db_sync.development_stands import _sync_development_stands
from walle.db_sync.inventory import db_sync_inventory_wrapper
from walle.db_sync.macs import db_sync_macs
from walle.db_sync.racktables_netmap import DB_SYNC_RACKTABLES_NETMAP_WORK_TIME, db_sync_racktables_netmap_wrapper
from walle.db_sync.eine_netmap import db_sync_eine_netmap
from walle.db_sync.physical_location import db_sync_bot_hardware_location_wrapper
from walle.db_sync.bot_project import DB_SYNC_BOT_PROJECT_ID_CHECK_PERIOD, db_sync_bot_project_id_wrapper
from walle.db_sync.rack_topology_sync import db_sync_rack_topology_wrapper
from walle.db_sync.network_data import sync_hosts_network_info_wrapper
from walle.default_cms import default_cms_tasks_scheduler, cms_maintenance_drop_stale_projects
from walle.downtimes import _gc_jobs
from walle.failure_reports.daily_reports import host_failure_reporter
from walle.failure_reports.gc import gc_reports
from walle.hbf_drills import _process_hbf_drills_wrapper
from walle.host_fsm.handbrake import _gc_global_fsm_handbrake, _gc_project_fsm_handbrake
from walle.host_health import _gc_outdated_host_health
from walle.host_macs import host_macs_gc
from walle.host_status import _gc_maintenance_timeout, _gc_maintenance_ticket_closed, _gc_complete_probation
from walle.idm.monitoring import report_idm_system_status
from walle.preorders import _process_preorders
from walle.profile_stat import sync_profile_stat
from walle.scenario.hsi_gc import _gc_old_host_stage_info
from walle.status_report import (
    report_global_automation_status,
    report_project_automation_status,
    report_plot_automation_status,
)
from walle.util.db_cache_gc import _gc_wrapper


def setup_cron(cron) -> None:
    crons = config.get_value("crons")

    if CronType.DB_CACHE_GC in crons:
        cron.add_job(
            CronType.DB_CACHE_GC, _gc_wrapper, 60 * constants.MINUTE_SECONDS, retry_period=10 * constants.MINUTE_SECONDS
        )

    if CronType.GC_HOSTS_WITH_MAINTENANCE_STATE_TIMEOUT in crons:
        cron.add_job(
            CronType.GC_HOSTS_WITH_MAINTENANCE_STATE_TIMEOUT, _gc_maintenance_timeout, constants.MINUTE_SECONDS
        )

    if CronType.GC_HOSTS_WITH_TICKET_FOR_MAINTENANCE in crons:
        cron.add_job(
            CronType.GC_HOSTS_WITH_TICKET_FOR_MAINTENANCE, _gc_maintenance_ticket_closed, 2 * constants.MINUTE_SECONDS
        )

    if CronType.GC_PROBATION_READY_TO_ASSIGNED in crons:
        cron.add_job(CronType.GC_PROBATION_READY_TO_ASSIGNED, _gc_complete_probation, constants.MINUTE_SECONDS)

    if CronType.GC_OUTDATED_HOST_HEALTH in crons:
        cron.add_job(CronType.GC_OUTDATED_HOST_HEALTH, _gc_outdated_host_health, constants.HOUR_SECONDS)

    if CronType.JUGGLER_DOWNTIMES_CHECK in crons:
        cron.add_job(CronType.JUGGLER_DOWNTIMES_CHECK, _gc_jobs, 10 * constants.MINUTE_SECONDS)

    if CronType.GC_ADMIN_REQUESTS in crons:
        cron.add_job(CronType.GC_ADMIN_REQUESTS, _gc_admin_requests, constants.MINUTE_SECONDS)

    if CronType.DEFAULT_CMS_TASKS_SCHEDULER in crons:
        cron.add_job(CronType.DEFAULT_CMS_TASKS_SCHEDULER, default_cms_tasks_scheduler, constants.MINUTE_SECONDS)

    if CronType.DEFAULT_CMS_PROJECT_DROP_MAINTENANCE in crons:
        cron.add_job(
            CronType.DEFAULT_CMS_PROJECT_DROP_MAINTENANCE, cms_maintenance_drop_stale_projects, constants.MINUTE_SECONDS
        )

    if CronType.GC_ABANDONED_CMS_TASKS in crons:
        cron.add_job(
            CronType.GC_ABANDONED_CMS_TASKS,
            _gc_cms,
            constants.MINUTE_SECONDS,
            expected_work_time=GC_ABANDONED_CMS_TASKS_WORK_TIME,
            stop_handler=_cms_gc.stop,
        )

    if CronType.DB_SYNC_DEVELOPMENT_STANDS in crons:
        if config.get_value("development_stands"):
            cron.add_job(CronType.DB_SYNC_DEVELOPMENT_STANDS, _sync_development_stands, 10 * constants.MINUTE_SECONDS)

    if CronType.DB_SYNC_INVENTORY in crons:
        cron.add_job(
            CronType.DB_SYNC_INVENTORY,
            db_sync_inventory_wrapper,
            15 * constants.MINUTE_SECONDS,
            stop_handler=db_sync_inventory_wrapper.stop,
        )

    if CronType.DB_SYNC_MACS in crons:
        if config.get_value("inventory_check.enabled"):
            cron.add_job(
                CronType.DB_SYNC_MACS, db_sync_macs, constants.DAY_SECONDS, retry_period=constants.HOUR_SECONDS
            )

    if CronType.DB_SYNC_RACKTABLES_NETMAP in crons:
        cron.add_job(
            CronType.DB_SYNC_RACKTABLES_NETMAP,
            db_sync_racktables_netmap_wrapper,
            10 * constants.MINUTE_SECONDS,
            retry_period=5 * constants.MINUTE_SECONDS,
            expected_work_time=DB_SYNC_RACKTABLES_NETMAP_WORK_TIME,
        )

    if CronType.DB_SYNC_EINE_NETMAP in crons:
        cron.add_job(
            CronType.DB_SYNC_EINE_NETMAP,
            db_sync_eine_netmap,
            10 * constants.MINUTE_SECONDS,
            retry_period=5 * constants.MINUTE_SECONDS,
        )

    if CronType.DB_SYNC_BOT_HARDWARE_LOCATION in crons:
        cron.add_job(
            CronType.DB_SYNC_BOT_HARDWARE_LOCATION,
            db_sync_bot_hardware_location_wrapper,
            10 * constants.MINUTE_SECONDS,
            retry_period=5 * constants.MINUTE_SECONDS,
        )

    if CronType.DB_SYNC_BOT_PROJECT_ID in crons:
        cron.add_job(
            CronType.DB_SYNC_BOT_PROJECT_ID, db_sync_bot_project_id_wrapper, DB_SYNC_BOT_PROJECT_ID_CHECK_PERIOD
        )

    if CronType.DB_SYNC_RACK_TOPOLOGY in crons:
        cron.add_job(
            CronType.DB_SYNC_RACK_TOPOLOGY,
            db_sync_rack_topology_wrapper,
            15 * constants.MINUTE_SECONDS,
            retry_period=5 * constants.MINUTE_SECONDS,
        )

    if CronType.SYNC_HOSTS_NETWORK_INFO in crons:
        cron.add_job(
            CronType.SYNC_HOSTS_NETWORK_INFO,
            sync_hosts_network_info_wrapper,
            constants.HOUR_SECONDS * 6,
            retry_period=10 * constants.MINUTE_SECONDS,
        )

    if CronType.PROFILE_STAT_SYNC in crons:
        cron.add_job(
            CronType.PROFILE_STAT_SYNC,
            sync_profile_stat,
            10 * constants.MINUTE_SECONDS,
            retry_period=5 * constants.MINUTE_SECONDS,
        )

    if CronType.PREORDERS_PROCESSOR in crons:
        if config.get_value("automation.enabled") and config.get_value("automation.process_preorders"):
            cron.add_job(CronType.PREORDERS_PROCESSOR, _process_preorders, 10 * constants.MINUTE_SECONDS)

    if CronType.HOST_MACS_GC in crons:
        cron.add_job(CronType.HOST_MACS_GC, host_macs_gc, constants.HOUR_SECONDS)

    if CronType.REPORT_GLOBAL_AUTOMATION in crons:
        cron.add_job(CronType.REPORT_GLOBAL_AUTOMATION, report_global_automation_status, constants.MINUTE_SECONDS)

    if CronType.REPORT_PROJECT_AUTOMATION in crons:
        cron.add_job(CronType.REPORT_PROJECT_AUTOMATION, report_project_automation_status, constants.MINUTE_SECONDS)

    if CronType.REPORT_PLOT_AUTOMATION in crons:
        cron.add_job(CronType.REPORT_PLOT_AUTOMATION, report_plot_automation_status, constants.MINUTE_SECONDS)

    if CronType.HOST_FAILURE_REPORTER in crons:
        if config.get_value("failure_reports.enabled"):
            cron.add_job(CronType.HOST_FAILURE_REPORTER, host_failure_reporter, constants.HOUR_SECONDS)

    if CronType.GC_REPORTS in crons:
        if config.get_value("failure_reports.enabled"):
            cron.add_job(CronType.GC_REPORTS, gc_reports, 1 * constants.HOUR_SECONDS)

    if CronType.GC_GLOBAL_FSM_HANDBRAKE in crons:
        cron.add_job(CronType.GC_GLOBAL_FSM_HANDBRAKE, _gc_global_fsm_handbrake, constants.MINUTE_SECONDS)

    if CronType.GC_PROJECT_FSM_HANDBRAKE in crons:
        cron.add_job(CronType.GC_PROJECT_FSM_HANDBRAKE, _gc_project_fsm_handbrake, constants.MINUTE_SECONDS)

    if CronType.REPORT_IDM_SYSTEM_STATUS in crons:
        cron.add_job(CronType.REPORT_IDM_SYSTEM_STATUS, report_idm_system_status, 5 * constants.MINUTE_SECONDS)

    if CronType.PREHEAT_GROUP_MEMBERS_CACHE in crons:
        cron.add_job(CronType.PREHEAT_GROUP_MEMBERS_CACHE, preheat_group_members_cache, constants.HOUR_SECONDS)

    if CronType.CAUTH_CERTIFICATE in crons:
        cron.add_job(CronType.CAUTH_CERTIFICATE, check_certificate_date, constants.DAY_SECONDS)

    if CronType.UPDATE_HBF_DRILLS in crons:
        cron.add_job(CronType.UPDATE_HBF_DRILLS, _process_hbf_drills_wrapper, 15 * constants.MINUTE_SECONDS)

    if CronType.GC_HOSTS_STAGE_INFO in crons:
        cron.add_job(CronType.GC_HOSTS_STAGE_INFO, _gc_old_host_stage_info, constants.HOUR_SECONDS)

    if CronType.SYNC_TIERS in crons:
        cron.add_job(CronType.SYNC_TIERS, _sync_tiers, 10 * constants.MINUTE_SECONDS)

    if CronType.SYNC_SHADOW_HOSTS in crons:
        cron.add_job(CronType.SYNC_SHADOW_HOSTS, _sync_shadow_hosts, 30 * constants.MINUTE_SECONDS)

    if CronType.CONFIG_REDEFINITION_MONITORING in crons:
        cron.add_job(CronType.CONFIG_REDEFINITION_MONITORING, _start_config_monintoring, 10 * constants.MINUTE_SECONDS)

    if CronType.DMC_SHARDS_PROCESSING in crons:
        cron.add_job(CronType.DMC_SHARDS_PROCESSING, _start_dmc_shards_processing, 1 * constants.MINUTE_SECONDS)

    if CronType.INFINIBAND_INFO_SYNC in crons:
        cron.add_job(CronType.INFINIBAND_INFO_SYNC, _infiniband_info_sync, 30 * constants.MINUTE_SECONDS)
