import random

from apscheduler.triggers.interval import IntervalTrigger, timedelta


class JitterIntervalTrigger(IntervalTrigger):
    __slots__ = 'jitter'

    def __init__(
        self, weeks=0, days=0, hours=0, minutes=0, seconds=0, start_date=None, end_date=None, timezone=None, jitter=0
    ):
        """all parameters are same as for IntervalTrigger, jitter is in seconds."""

        super().__init__(
            weeks=weeks,
            days=days,
            hours=hours,
            minutes=minutes,
            seconds=seconds,
            start_date=start_date,
            end_date=end_date,
            timezone=timezone,
        )

        self.jitter = jitter

    def get_next_fire_time(self, previous_fire_time, now):
        next_fire_time = super().get_next_fire_time(previous_fire_time, now)
        return next_fire_time + timedelta(milliseconds=random.randint(self.jitter * -1000, self.jitter * 1000))
