import zlib

from .base import BaseEncoder


def get_compression_level(content_type):
    if content_type == 'application/json':
        return 2  # Don't try too hard on dynamic data, we target response times
    return 6


class Deflate(BaseEncoder):
    content_encoding = 'deflate'

    def compress(self, data, content_type=None):
        return zlib.compress(data, get_compression_level(content_type))
