from flask import request

from .deflate_encoder import Deflate


def should_encode(response):
    if 'Content-Encoding' in response.headers:
        return False
    return 200 <= response.status_code < 300


class ContentEncoder:
    def __init__(self, skip_content_type=None, encoders=(Deflate(),)):
        self.app = None
        self.skip_content_type = skip_content_type
        self.encoders = {encoder.content_encoding: encoder for encoder in encoders}

    def init_app(self, app):
        self.app = app
        self.app.after_request(self.after_request)

    def after_request(self, response):
        if not should_encode(response):
            return response
        for acc_encoding in request.headers.get('Accept-Encoding', '').lower().split(','):
            acc_encoding = acc_encoding.strip()
            if acc_encoding in self.encoders:
                encoder = self.encoders[acc_encoding]
                response = encoder.after_request(response)
        return response
