import gzip
import io

from .base import BaseEncoder


def get_compression_level(content_type):
    if content_type == 'application/json':
        return 3  # Don't try to hard on dynamic data, we target response times
    return 6


class Gzip(BaseEncoder):
    content_encoding = 'gzip'

    def __init__(self, *args, **kwargs):
        self.buffer_class = kwargs.pop('buffer_class', io.BytesIO)
        super().__init__(*args, **kwargs)

    def compress(self, data, content_type=None):
        level = get_compression_level(content_type)
        gzip_buffer = self.buffer_class()
        gzip_file = gzip.GzipFile(mode='wb', compresslevel=level, fileobj=gzip_buffer)
        gzip_file.write(data)
        gzip_file.close()
        return gzip_buffer.getvalue()
