import logging
import typing as tp


log = logging.getLogger(__name__)


class ItemWithCounter(tp.Protocol):
    counter: int


ItemId = tp.TypeVar('ItemId')


class CounterChecker:
    def __init__(self, item_log_description):
        self._counter_cache = {}
        self._item_log_description = item_log_description

    def check_for_fresh(self, item_id: ItemId, item_with_counter: tp.Optional[ItemWithCounter]) -> bool:
        if not item_with_counter:
            return False
        current_decision_counter = item_with_counter.counter
        prev_decision_counter = self._counter_cache.get(item_id)
        self._counter_cache[item_id] = current_decision_counter
        if prev_decision_counter is None:
            return False

        if prev_decision_counter >= current_decision_counter:
            log.error(
                (
                    f"Failed to get {self._item_log_description} %s: current decision counter <%i>, "
                    f"prev viewed decision counter <%i>"
                ),
                item_id,
                current_decision_counter,
                prev_decision_counter,
            )
            return False
        return True
