import logging

from sepelib.core import constants
from walle.util.db_cache import gc_cache

log = logging.getLogger(__name__)


# Maximum TTL of cache is 1 Week TODO: Remove when all cache has ttl
MAX_CACHE_TTL = constants.WEEK_SECONDS


def _gc():
    gc_cache(MAX_CACHE_TTL)


def _gc_wrapper():
    try:
        _gc()
    except Exception as e:
        log.exception("Failed to collect db_cache garbage: %s", e)
        return False
