"""Utility functions for host health reasons."""

import logging

from walle.expert.types import CheckStatus, get_walle_check_type

log = logging.getLogger(__name__)


def get_human_reasons(reasons, check_types=None):
    return sorted(
        get_failure_reason(check_type, info["status"])
        for check_type, info in reasons.items()
        if (check_types is None or check_type in check_types) and info["status"] != CheckStatus.PASSED
    )


def get_reasons_for_log(reasons, check_types=None):
    return sorted(
        "{}/{}".format(get_failure_reason(check_type, info["status"]), info.get("effective_timestamp", "-"))
        for check_type, info in reasons.items()
        if (check_types is None or check_type in check_types) and info["status"] != CheckStatus.PASSED
    )


def get_failure_reason(check_type, check_status):
    """Returns a failure reason from check type and its status."""

    return get_walle_check_type(check_type) + "." + check_status


def get_failure_reason_deprecated(check_type, check_status):
    """Returns a failure reason from check type and its status."""

    return get_walle_check_type(check_type) + "-" + check_status
