import re

from sepelib.core import config


def get_stand_uid():
    return config.get_value("juggler.source")


def normalize(name, substitution="."):
    return re.sub(r"[^-\w]", substitution, name or "")


def get_aggregate_name(short_queue_name, rack):
    stand_uid = get_stand_uid()
    parts = [stand_uid, normalize(short_queue_name), normalize(rack)]

    return "-".join(filter(None, parts))
