"""Handy class representing an optional result of an operation."""


class Optional:
    """Represent an optional result of an operation."""

    def __init__(self, value):
        self._value = value

    def __bool__(self):
        return self._value is not None

    def __nonzero__(self):
        return self.__bool__()

    def __iter__(self):
        return filter(None, [self._value])

    def or_else(self, func):
        if bool(self):
            return self
        else:
            cls = type(self)
            return cls(func())

    def or_throw(self, exception):
        if bool(self):
            return self._value
        else:
            raise exception

    def get(self):
        return self._value


class Either(Optional):
    """Represent an optionally successful result of an operation (think Optional but for boolean values)."""

    def __bool__(self):
        return self._value

    def __nonzero__(self):
        return self.__bool__()

    def then(self, func):
        if bool(self):
            cls = type(self)
            return cls(func())
        else:
            return self
