import re


def parse_pattern(pattern, by_prefix=False):
    """Compile glob-style pattern into regex. Constraints are:
    * if there is not wildcards in the pattern, compile it into "substring pattern" without any wildcards and anchors.
    * if there is wildcard in the edge of the pattern, compile it into .* rule
    * if there is no wildcard at the edge on the pattern, this edge is anchored, e.g. ^sas1... or ...net$.
    See tests for examples.
    """
    if by_prefix:
        return re.compile("^{}".format(re.escape(pattern)))
    elif "*" not in pattern:
        return re.compile(re.escape(pattern), re.IGNORECASE)
    else:
        return re.compile("^{}$".format(".*".join(map(re.escape, pattern.split("*")))), re.IGNORECASE)
