import library.python.resource as resource
import six
from jinja2 import BaseLoader, Environment

TEMPLATE_DIR = "templates"


class JinjaTemplateRenderer:
    def __init__(self):
        self.env = Environment(loader=BaseLoader())

    def render_template(self, template_name, **kwargs):
        path = "{}/{}".format(TEMPLATE_DIR, template_name)
        if not resource.resfs_file_exists(path):
            raise RuntimeError("Fail to find template {} in resources".format(path))
        template_body = resource.resfs_read(path)
        template = self.env.from_string(six.ensure_text(template_body, "utf-8"))
        output = template.render(**kwargs)
        return output
