"""Some nice and useful text functions"""

from datetime import timedelta

from sepelib.core.constants import HOUR_SECONDS, MINUTE_SECONDS


def enumeration_join(items, comma=", ", last=" and "):
    if len(items) == 0:
        return ""
    elif len(items) == 1:
        return items[0]
    else:
        return last.join((comma.join(items[:-1]), items[-1]))


def time_range_message(min_timeout, max_timeout):
    minimum = timedelta(seconds=min_timeout)
    maximum = timedelta(seconds=max_timeout)

    return "from {} to {}".format(fmt_timedelta(minimum), fmt_timedelta(maximum))


def fmt_timedelta(td):
    res = [
        _fmt_timedelta_level(td.days, "day", "days"),
        _fmt_timedelta_level(td.seconds // HOUR_SECONDS, "hour", "hours"),
        _fmt_timedelta_level(td.seconds % HOUR_SECONDS // MINUTE_SECONDS, "minute", "minutes"),
        _fmt_timedelta_level(td.seconds % MINUTE_SECONDS, "second", "seconds"),
    ]

    return " ".join(filter(None, res))


def _fmt_timedelta_level(value, singular, plural):
    if value > 1:
        return "{} {}".format(value, plural)
    elif value:
        return "1 {}".format(singular)
    else:
        return ""


def shrink_string(s, maxlen=700):
    shorten_str = ' ... '

    if len(s) > maxlen:
        idx = int(maxlen / 2) - int(len(shorten_str) / 2)
        return s[:idx] + shorten_str + s[(len(s) - idx + 1) :]

    else:
        return s
