"""Method to validate checks."""

from walle.errors import BadRequestError
from walle.views.helpers.constants import CheckFields


def validate_checks_list(checks):
    if len({check[CheckFields.NAME] for check in checks}) != len(checks):
        raise BadRequestError("Check names must be unique for automation plot.")

    for check in checks:
        if (
            check[CheckFields.REBOOT] or check[CheckFields.REDEPLOY] or check.get(CheckFields.PROFILE, False)
        ) and not check[CheckFields.REPORT_FAILURE]:
            raise BadRequestError(
                "Checks with enabled 'reboot'/'profile'/'redeploy' and disabled 'report' are not allowed."
            )
