"""Tools to check working hours."""

import datetime
import time

WEEKDAY_MON = 1
WEEKDAY_TUE = 2
WEEKDAY_WED = 3
WEEKDAY_THU = 4
WEEKDAY_FRI = 5
WEEKDAY_SAT = 6
WEEKDAY_SUN = 7

WORKING_DAYS = {WEEKDAY_MON, WEEKDAY_TUE, WEEKDAY_WED, WEEKDAY_THU, WEEKDAY_FRI}
HOST_MAINTENANCE_HOURS = (datetime.time(11, 00), datetime.time(17, 55))
REPORTS_WORKING_HOURS = (datetime.time(9, 00), datetime.time(23, 00))
NOC_MAINTENANCE_HOURS = (datetime.time(9, 00), datetime.time(19, 30))


def to_timestamp(value):
    return int(time.mktime(value.timetuple()))


def from_timestamp(timestamp):
    return datetime.datetime.fromtimestamp(timestamp)


def next_working_hour_timestamp(timestamp, working_days, wh_start, wh_end):
    """Check if now is working hours.
    NB: does not work correctly if wh_end less then wh_start, e.g. if wh ends after midnight.
    It kind of does not make sense if wh ends after midnight, because while workday concept fails apart.
    """

    now = from_timestamp(timestamp)
    # First-shot simplest implementation:
    # * working days are Mon thru Fri
    # * working hours are 11:00 thru 17:55

    if now.isoweekday() in working_days and wh_start <= now.time() <= wh_end:
        return to_timestamp(now)
    else:
        next_time = now.replace(hour=wh_start.hour, minute=wh_start.minute, second=0, microsecond=0)
        step = datetime.timedelta(days=1)
        if now.time() > wh_end:
            # special case for weekday but afterhours
            # beforehours and holydays do not require this
            next_time += step

        while next_time.isoweekday() not in working_days:
            next_time += step

        return to_timestamp(next_time)
