"""Put all JSON-schemas here."""
from walle.expert.automation_plot import AutomationPlot, Check
from walle.views.helpers.constants import CheckFields


def get_automation_plot_schema(full=True):
    schema = {
        "type": "object",
        "properties": {
            "name": {
                "type": "string",
                "minLength": AutomationPlot.name.min_length,
                "maxLength": AutomationPlot.name.max_length,
                "description": "Name that will identify automation plot in UI",
            },
            "owners": _get_owners_schema("Automation plot owners"),
            "checks": {
                "type": "array",
                "items": _get_check_schema(),
            },
            "yc_iam_folder_id": {"type": "string", "description": "YC Folder ID"},
        },
        "additionalProperties": False,
    }

    if full:
        schema["properties"]["id"] = {
            "type": "string",
            "pattern": AutomationPlot.id.regex.pattern,
            "maxLength": AutomationPlot.id.max_length,
            "description": "A unique ID",
        }
        schema["required"] = ["id", "name"]

    return schema


def _get_owners_schema(description):
    return {
        "type": "array",
        "items": {"type": "string", "pattern": AutomationPlot.owners.field.regex.pattern},
        "description": description,
    }


def _get_check_schema():
    schema = {
        "type": "object",
        "description": "Check properties",
        "properties": {
            CheckFields.NAME: {
                "type": "string",
                "pattern": Check.name.regex.pattern,
                "maxLength": Check.name.max_length,
                "description": "Juggler check name",
            },
            CheckFields.ENABLED: {"type": "boolean", "description": "Enable check, default is true"},
            CheckFields.WAIT: {
                "type": "boolean",
                "description": "Try to wait until failure fixes itself, default is false",
            },
            CheckFields.REBOOT: {
                "type": "boolean",
                "description": "Try to reboot host to fix failure, default is false",
            },
            CheckFields.PROFILE: {
                "type": "boolean",
                "description": "Try to profile host to fix failure, default is false",
            },
            CheckFields.REDEPLOY: {
                "type": "boolean",
                "description": "Try to redeploy host to fix failure, default is false",
            },
            CheckFields.REPORT_FAILURE: {
                "type": "boolean",
                "description": "Try to report about problem, default is true",
            },
        },
        "required": ["name"],
        "additionalProperties": False,
    }

    return schema
