from walle import boxes
from walle.util.api import api_handler, api_response


@api_handler("/boxes", "GET")
def get_boxes():
    """Provides collection of all known boxes and their types."""

    return api_response(
        {
            boxes.BoxType.dns: {n: b.to_api() for n, b in boxes.get_all_dns_boxes().items()},
            boxes.BoxType.eine: {n: b.to_api() for n, b in boxes.get_all_eine_boxes().items()},
        }
    )
