"""Deploy configs"""  # Will be used as category name in API reference

import logging

from sepelib.core.exceptions import Error
from walle import constants as walle_constants
from walle.clients import inventory
from walle.util.api import api_handler, api_response

log = logging.getLogger(__name__)


@api_handler(
    "/deploy-configs",
    "GET",
    params={
        "provisioner": {
            "type": "array",
            "items": {"enum": walle_constants.PROVISIONERS, "description": "Filter by provisioner"},
        },
    },
)
def get_configs(query_args):
    """Returns all available deploy configs."""

    configs_by_provisioner = {}

    for provisioner in set(query_args.get("provisioner", walle_constants.PROVISIONERS)):
        try:
            if provisioner == walle_constants.PROVISIONER_LUI:
                configs = inventory.get_lui_configs()
            elif provisioner == walle_constants.PROVISIONER_EINE:
                configs = inventory.get_eine_profiles()
            else:
                raise Error("Unknown provisioner.")
        except Exception as e:
            log.error("Failed to get a list of available configs for %s provisioner: %s", provisioner, e)
            configs = []

        configs_by_provisioner[provisioner] = sorted(configs)

    return api_response(configs_by_provisioner)
