"""DNS"""  # Will be used as category name in API reference

import operator as op

from walle.network import BlockedHostName
from walle.util.api import api_handler, api_response, get_query_result
from walle.util.gevent_tools import gevent_idle_iter


@api_handler(
    "/dns/blocked-host-names",
    "GET",
    with_paging={
        "cursor": {"type": "number", "minimum": 0, "description": "Event time to start the search from"},
        "cursor_only": True,
        "max_limit": 100000,
        "default_limit": 100000,
    },
)
def get_blocked_host_names(query_args):
    """Returns list of hostnames that was renamed some time ago."""

    get_fqdn = op.itemgetter("fqdn")
    api_response_object = get_query_result(BlockedHostName, [], BlockedHostName.release_timestamp, query_args)
    api_response_object["result"] = list(map(get_fqdn, gevent_idle_iter(api_response_object["result"])))

    return api_response(api_response_object)
