"""Wall-E main page."""

import logging
import mimetypes

import library.python.resource as resource
import simplejson as json
from flask import abort, Response

from sepelib.core import config
from sepelib.flask.h.decorators import templated
from walle.application import app
from walle.util import api

log = logging.getLogger(__name__)


@app.flask.route('/static/<path:filename>', methods=['GET'])
def static_file(filename):
    resource_file = "static/{}".format(filename)
    if resource.resfs_file_exists(resource_file):
        mimetype, encoding = mimetypes.guess_type(filename)
        return Response(resource.resfs_read(resource_file), mimetype=mimetype)

    abort(404)


@app.flask.route("/")
@templated("templates/index.html")
def index():
    return {
        "json": json,
        "api_reference": api.get_api_reference(),
        "url_prefix": config.get_value("web.http.url_prefix"),
    }
