"""Physical location tree"""  # Will be used as category name in API reference

import mongoengine

from walle.errors import ResourceNotFoundError
from walle.physical_location_tree import build_tree_for_project, build_tree_from_bot
from walle.util.api import api_handler, api_response


@api_handler(
    "/physical-location-tree",
    "GET",
    params={
        "project": {
            "type": "array",
            "items": {"type": "string", "minLength": 1, "description": "Comma-separated list of project IDs"},
        }
    },
)
def get_physical_location_tree(query_args):
    """Returns tree of all known physical locations for hosts."""

    projects = query_args.get("project")

    if projects is None:
        try:
            location_tree = build_tree_from_bot()
        except mongoengine.DoesNotExist:
            raise ResourceNotFoundError("Physical locations tree doesn't exist.")
    else:
        location_tree = build_tree_for_project(projects)

    return api_response(location_tree)
