from sepelib.core import config
from walle.clients.idm import BatchRequest
from walle.idm import project_push, role_storage
from walle.idm.project_role_managers import ProjectRole


def on_project_add(project, issuer_login, owners, enable_reboot_via_ssh=False):
    if config.get_value("idm.push_api_enabled"):
        with BatchRequest() as br:
            project_push.add_project_role_tree_nodes(br, project)

            role_manager = ProjectRole.get_role_manager(ProjectRole.OWNER, project)

            if issuer_login in owners:
                role_manager.request_add_member(br, issuer_login, issuer_login, with_autoapprove=True)

            for member in set(owners) - {issuer_login}:
                role_manager.request_add_member(br, issuer_login, member)

            if enable_reboot_via_ssh:
                role_manager = ProjectRole.get_role_manager(ProjectRole.SSH_REBOOTER, project)
                role_manager.request_add_member(br, issuer_login)

            br.execute()


def on_project_delete(project):
    if config.get_value("idm.push_api_enabled"):
        with BatchRequest() as br:
            project_push.delete_project_role_tree_nodes(br, project)
            br.execute()
        role_storage.remove_all_roles_for_project(project)


def on_project_clone(project, orig_project_id):
    if config.get_value("idm.push_api_enabled"):
        with BatchRequest() as br:
            project_push.add_project_role_tree_nodes(br, project)
            project_push.request_project_role_clones(br, project, orig_project_id)
            br.execute()


def on_project_owners_update(project, issuer_login, owners_to_add, owners_to_remove):
    if config.get_value("idm.push_api_enabled"):
        with BatchRequest() as br:
            role_manager = ProjectRole.get_role_manager(ProjectRole.OWNER, project)
            for member in owners_to_add:
                role_manager.request_add_member(br, issuer_login, member)
            for member in owners_to_remove:
                role_manager.request_remove_member(br, member)
            br.execute()
