from walle.errors import BadRequestError
from walle.util.misc import InvOrUUIDOrName


def get_hosts_invs(hosts):
    # WALLE-3856 Do not look for host's invs for scenario that adds hosts, only check and convert them to integers.
    if not hosts:
        return []

    result = []
    error_values = []
    for host in hosts:
        obj = InvOrUUIDOrName(host)
        if not obj.is_inv():
            error_values.append(obj.value())
        else:
            result.append(obj.value())
    if error_values:
        raise BadRequestError(
            "Hosts-transfer scenario can use only invs. "
            "If next values are invs, please report to Wall-e Devs: {}".format(", ".join(error_values))
        )
    return result
