from walle.models import DocumentPostprocessor
from walle.scenario.scenario import Scenario
from walle.util.gevent_tools import gevent_idle_iter


class ScenarioPostprocessor(DocumentPostprocessor):
    def __init__(self):
        extra_db_fields = {Scenario.hosts.db_field}
        extra_fields = {Scenario.hosts.db_field}
        super().__init__(extra_db_fields, extra_fields)

    def process(self, iterable, requested_fields):
        scenarios = []

        for scenario in gevent_idle_iter(iterable):
            scenario_dict = scenario.to_api_object_shallow(requested_fields)
            # flat view for UI: WALLE-2270
            scenario_dict[Scenario.hosts.db_field] = list(scenario_dict[Scenario.hosts.db_field].values())

            scenarios.append(scenario_dict)

        return scenarios
