"""API to some third-party data."""

from walle.clients import bot, racktables
from walle.util.api import api_handler, api_response


@api_handler("/bot-projects", "GET")
def get_bot_projects():
    """Returns list of hostnames that was renamed some times ago."""
    return api_response(bot.get_oebs_projects_tree())


@api_handler("/hbf-projects", "GET")
def get_hbf_projects():
    """Returns list of hbf (mtn) projects and their names."""

    return api_response(
        [{"id": hex(project_id)[2:], "name": name} for project_id, name in racktables.get_hbf_projects().items()]
    )
