from walle.constants import HostType
from walle.errors import BadRequestError
from walle.hosts import Host
from walle.util.misc import InvOrUUIDOrName
from walle.util.mongo import MongoDocument


def get_hosts_objs_from_unknown_hosts_identifiers(hosts, fields=None):
    if not hosts:
        return []

    obj = InvOrUUIDOrName(hosts[0])
    if obj.is_inv():
        mongo_field_name = "inv"
    elif obj.is_uuid():
        mongo_field_name = "_id"
    else:
        mongo_field_name = "name"

    query = {
        mongo_field_name: {"$in": [InvOrUUIDOrName(_host).value() for _host in hosts]},
        "type": {"$in": [HostType.SERVER, HostType.SHADOW_SERVER]},
    }

    if not fields:
        fields = ["inv", "project"]
    projection = {"_id": 0}
    for field in fields:
        projection[field] = 1
    host_query_result = list(MongoDocument.for_model(Host).find(query, projection))

    if len(host_query_result) < len(hosts):
        raise BadRequestError("Can not find some hosts' inventory numbers.")

    return [host for host in host_query_result]
