import logging

from sepelib.core import config
from walle.application import app
from walle.models import timestamp
from walle.util.api import api_response, generic_api_handler

log = logging.getLogger(__name__)


def api_handler(*args, **kwargs):
    return generic_api_handler(
        app.profile_blueprint, *args, oauth_client_id=config.get_value("cms.client_id"), **kwargs
    )


@api_handler("/start", "GET", include_to_api_reference=False)
def profiler_start():
    app.yappi.start()
    return api_response({"status": "profiler started"})


@api_handler("/stop", "GET", include_to_api_reference=False)
def profiler_stop():
    app.yappi.stop()
    return api_response({"status": "profiler stopped"})


@api_handler("/save", "GET", include_to_api_reference=False)
def profiler_save():
    app_roles = "_".join(sorted(app.services))
    path_prefix = config.get_value("profiler_log.path_prefix")
    output_path = "{}_{}_{}.pstat".format(path_prefix, app_roles, timestamp())

    try:
        app.yappi.get_func_stats().save(output_path, type="PSTAT")
        return api_response({"status": "profiler saved stats"})
    except TypeError as e:
        return api_response({"status": "profiler couldn't save stats, please start it first: {}".format(e)})
