PY3_LIBRARY()

STYLE_PYTHON()

OWNER(g:walle)

PY_SRCS(
    NAMESPACE walle
    __init__.py
    _tasks/__init__.py
    _tasks/sb_helpers.py
    _tasks/stages.py
    _tasks/task_args.py
    _tasks/task_creator.py
    _tasks/task_provider.py
    _tasks/utils.py
    admin_requests/__init__.py
    admin_requests/constants.py
    admin_requests/request.py
    admin_requests/severity.py
    application.py
    audit_log.py
    authorization/__init__.py
    authorization/blackbox.py
    authorization/csrf.py
    authorization/iam.py
    authorization/types.py
    authorization/user_info.py
    base_fsm.py
    boxes.py
    cauth.py
    clients/__init__.py
    clients/abc.py
    clients/bot.py
    clients/calendar.py
    clients/cauth.py
    clients/certificator.py
    clients/cms.py
    clients/deploy.py
    clients/dns/__init__.py
    clients/dns/client_wrapper.py
    clients/dns/interface.py
    clients/dns/local_dns_resolver.py
    clients/dns/operations.py
    clients/dns/slayer_dns_api.py
    clients/dns/rurikk_dns_api.py
    clients/dmc.py
    clients/eine.py
    clients/hbf.py
    clients/iam.py
    clients/idm.py
    clients/inventory.py
    clients/ipmiproxy.py
    clients/juggler.py
    clients/netmon.py
    clients/network/__init__.py
    clients/network/netmap.py
    clients/network/network_client.py
    clients/network/racktables_client.py
    clients/oauth.py
    clients/ok.py
    clients/otrs.py
    clients/qloud.py
    clients/racktables.py
    clients/ssh.py
    clients/staff.py
    clients/startrek.py
    clients/tvm.py
    clients/vlan_toggler.py
    clients/utils.py
    clients/yasubr.py
    cms.py
    cms_models.py
    constants.py
    credentials.py
    cron/__init__.py
    cron/config_redefinition_monitoring.py
    cron/dmc_shards_processing.py
    cron/infiniband_info_sync.py
    cron/shadow_hosts_sync.py
    cron/tier_sync.py
    db_sync/__init__.py
    db_sync/bot_project.py
    db_sync/development_stands.py
    db_sync/eine_netmap.py
    db_sync/inventory.py
    db_sync/macs.py
    db_sync/network_data.py
    db_sync/physical_location.py
    db_sync/rack_topology_sync.py
    db_sync/racktables_netmap.py
    default_cms.py
    dns/dns_lib.py
    dns/dns_fixer.py
    downtimes.py
    errors.py
    expert/__init__.py
    expert/automation/__init__.py
    expert/automation/automation_context.py
    expert/automation/global_automation.py
    expert/automation/limits.py
    expert/automation/project_automation.py
    expert/automation_plot.py
    expert/checks.py
    expert/constants.py
    expert/decision.py
    expert/decisionmakers.py
    expert/dmc.py
    expert/failure_log.py
    expert/failure_types.py
    expert/juggler.py
    expert/netmon.py
    expert/rack_topology.py
    expert/rules/__init__.py
    expert/rules/availability_check.py
    expert/rules/base.py
    expert/rules/common.py
    expert/rules/configurable.py
    expert/rules/escalation.py
    expert/rules/hw_watcher_rules/__init__.py
    expert/rules/hw_watcher_rules/check_bmc.py
    expert/rules/hw_watcher_rules/check_cpu_caches.py
    expert/rules/hw_watcher_rules/check_cpu_thermal.py
    expert/rules/hw_watcher_rules/check_disk.py
    expert/rules/hw_watcher_rules/check_gpu.py
    expert/rules/hw_watcher_rules/check_infiniband.py
    expert/rules/hw_watcher_rules/check_link.py
    expert/rules/hw_watcher_rules/check_memory.py
    expert/rules/hw_watcher_rules/util.py
    expert/rules/meta_rules.py
    expert/rules/missing_passive_checks_rule.py
    expert/rules/utils.py
    expert/rules/walle_check_rules.py
    expert/rules/walle_ib_link_rule.py
    expert/rules/walle_rack_rules.py
    expert/schemes.py
    expert/screening.py
    expert/triage.py
    expert/types.py
    failure_reports/__init__.py
    failure_reports/base.py
    failure_reports/cms_reports.py
    failure_reports/daily_reports.py
    failure_reports/gc.py
    failure_reports/observers.py
    failure_reports/project_reports.py
    failure_reports/rack_reports.py
    failure_reports/reports.py
    failure_reports/startrek.py
    fsm_stages/__init__.py
    fsm_stages/acquire_permission.py
    fsm_stages/add_host_to_cauth.py
    fsm_stages/allocate_hostname.py
    fsm_stages/assign_bot_project.py
    fsm_stages/assign_hostname.py
    fsm_stages/cancel_admin_requests.py
    fsm_stages/certificate.py
    fsm_stages/change_disk.py
    fsm_stages/check_host_preorder_status.py
    fsm_stages/cloud_post_processor.py
    fsm_stages/common.py
    fsm_stages/complete_deletion.py
    fsm_stages/complete_preparing.py
    fsm_stages/complete_releasing.py
    fsm_stages/constants.py
    fsm_stages/deactivate.py
    fsm_stages/dns.py
    fsm_stages/drop_cms_task.py
    fsm_stages/eine_profiling.py
    fsm_stages/foobar.py
    fsm_stages/fqdn_deinvalidation.py
    fsm_stages/handlers.py
    fsm_stages/hw_errors.py
    fsm_stages/hw_repair.py
    fsm_stages/ipmi_errors.py
    fsm_stages/kexec_ssh.py
    fsm_stages/log_completed_operation.py
    fsm_stages/lui_deploying.py
    fsm_stages/monitor.py
    fsm_stages/network_location.py
    fsm_stages/power_ipmi.py
    fsm_stages/power_post_util.py
    fsm_stages/power_ssh.py
    fsm_stages/provide_diagnostic_host_access.py
    fsm_stages/report_check_failure.py
    fsm_stages/report_rack_overheat.py
    fsm_stages/report_rack_unavailable.py
    fsm_stages/reset_bmc.py
    fsm_stages/reset_health_status.py
    fsm_stages/set_downtime.py
    fsm_stages/set_host_state.py
    fsm_stages/startrek_report.py
    fsm_stages/switch_default_cms_project.py
    fsm_stages/switch_project.py
    fsm_stages/vlan_switching.py
    hbf_drills.py
    host_shard.py
    host_fsm/__init__.py
    host_fsm/control.py
    host_fsm/fsm.py
    host_fsm/handbrake.py
    host_health.py
    host_macs.py
    host_network.py
    host_operations.py
    host_platforms/__init__.py
    host_platforms/errors.py
    host_platforms/platform.py
    host_platforms/platform_manager.py
    host_platforms/supported_platforms/__init__.py
    host_platforms/supported_platforms/aic.py
    host_platforms/supported_platforms/asus.py
    host_platforms/supported_platforms/gigabyte.py
    host_platforms/supported_platforms/quanta.py
    host_platforms/supported_platforms/supermicro.py
    host_status.py
    hosts.py
    idm/__init__.py
    idm/common.py
    idm/monitoring.py
    idm/node_views.py
    idm/project_push.py
    idm/project_role_managers.py
    idm/project_staff_id_converter.py
    idm/role_storage.py
    idm/role_tree.py
    idm/traversal.py
    idm/tree_views.py
    juggler.py
    locks.py
    main.py
    maintenance_plot/model.py
    maintenance_plot/common_settings.py
    maintenance_plot/constants.py
    maintenance_plot/exceptions.py
    maintenance_plot/jsonschema.py
    maintenance_plot/scenarios_settings/base.py
    maintenance_plot/scenarios_settings/hosts_transfer.py
    maintenance_plot/scenarios_settings/itdc_maintenance.py
    maintenance_plot/scenarios_settings/noc_hard.py
    maintenance_plot/scenarios_settings/noc_soft.py
    maintenance_plot/crud.py
    metrics.py
    models.py
    network.py
    operations_log/__init__.py
    operations_log/constants.py
    operations_log/operations.py
    physical_location_tree.py
    preorders.py
    profile_stat.py
    project_builder.py
    projects.py
    request.py
    restrictions.py
    scenario/__init__.py
    scenario/authorization.py
    scenario/cms.py
    scenario/common.py
    scenario/constants.py
    scenario/control.py
    scenario/data_storage/base.py
    scenario/data_storage/data_storage.py
    scenario/data_storage/exceptions.py
    scenario/data_storage/types.py
    scenario/definitions/__init__.py
    scenario/definitions/base.py
    scenario/definitions/types.py
    scenario/error_handlers.py
    scenario/errors.py
    scenario/handlers.py
    scenario/host_groups_builders/base.py
    scenario/host_groups_builders/by_bot_project_id.py
    scenario/host_groups_builders/by_specific_project_tag.py
    scenario/host_groups_builders/by_maintenance_plot.py
    scenario/host_groups_builders/constants.py
    scenario/host_groups_builders/exceptions.py
    scenario/host_groups_builders/hosts_list_splitters.py
    scenario/host_groups_builders/hosts_properties_getter.py
    scenario/host_groups_builders/maintenance_plot_getters.py
    scenario/host_stage_info.py
    scenario/hsi_gc.py
    scenario/iteration_strategy.py
    scenario/maintenance.py
    scenario/maintenance_plot_checks.py
    scenario/marker.py
    scenario/mixins.py
    scenario/qloud.py
    scenario/scenario.py
    scenario/scenario_fsm.py
    scenario/scheduler.py
    scenario/script.py
    scenario/script_args.py
    scenario/script_builder.py
    scenario/stage/__init__.py
    scenario/stage/acquire_permission.py
    scenario/stage/approve_stage.py
    scenario/stage/noc_hard_host_group_approve_stage.py
    scenario/stage/conditional_host_stage.py
    scenario/stage/create_startrek_ticket.py
    scenario/stage/detect_storage_stage.py
    scenario/stage/ensure_dns_access_stage.py
    scenario/stage/host_group_approve_stage.py
    scenario/stage/host_group_scheduler_stage.py
    scenario/stage/host_group_wait_before_requesting_cms_stage.py
    scenario/stage/lambda_stage.py
    scenario/stage/maintenance_approvers_workflow_stage.py
    scenario/stage/noc_maintenance_stage.py
    scenario/stage/scheduler_stage.py
    scenario/stage/timeout_stage.py
    scenario/stage_info.py
    scenario/stages.py
    scenario/utils.py
    scenario/validators.py
    setup_cron.py
    shadow_hosts.py
    stages.py
    statbox/__init__.py
    statbox/contexts.py
    statbox/handlers.py
    statbox/loggers.py
    stats.py
    status_report.py
    tasks.py
    trypo_radix.py
    util/__init__.py
    util/api.py
    util/approvement_tools.py
    util/apscheduler.py
    util/cache.py
    util/cert.py
    util/cloud_tools.py
    util/content_encoding/__init__.py
    util/content_encoding/base.py
    util/content_encoding/deflate_encoder.py
    util/content_encoding/encoder.py
    util/content_encoding/gzip_encoder.py
    util/cron.py
    util/counter.py
    util/db_cache.py
    util/db_cache_gc.py
    util/deploy_config.py
    util/error_booster.py
    util/gevent_tools.py
    util/host_health.py
    util/juggler.py
    util/jsonschema.py
    util/limits.py
    util/log_tools.py
    util/misc.py
    util/mongo/__init__.py
    util/mongo/bulk_group.py
    util/mongo/document.py
    util/mongo/geo_hints.py
    util/mongo/lock.py
    util/mongo/partitioner.py
    util/mongo/retry.py
    util/net.py
    util/notifications.py
    util/optional.py
    util/patterns.py
    util/rate_limiter.py
    util/setup.py
    util/tasks.py
    util/template_loader.py
    util/text.py
    util/validate_checks.py
    util/validation.py
    util/workdays.py
    views/__init__.py
    views/api/__init__.py
    views/api/audit_log_api.py
    views/api/automation_plot_api/__init__.py
    views/api/automation_plot_api/crud.py
    views/api/automation_plot_api/request_schemas.py
    views/api/box_api/__init__.py
    views/api/box_api/get.py
    views/api/cauth_api.py
    views/api/common.py
    views/api/constants_api.py
    views/api/dc_shortnames_api.py
    views/api/deploy_config_api.py
    views/api/dns_api.py
    views/api/health_check_api/__init__.py
    views/api/health_check_api/health_check_api.py
    views/api/host_api/__init__.py
    views/api/host_api/agent.py
    views/api/host_api/common.py
    views/api/host_api/debug.py
    views/api/host_api/info.py
    views/api/host_api/modification.py
    views/api/host_api/operations.py
    views/api/idm_api.py
    views/api/index.py
    views/api/maintenance_plot_api/__init__.py
    views/api/maintenance_plot_api/crud.py
    views/api/maintenance_plot_api/common.py
    views/api/operation_log_api.py
    views/api/physical_location_tree.py
    views/api/preorder_api.py
    views/api/project_api/__init__.py
    views/api/project_api/change_handlers.py
    views/api/project_api/common.py
    views/api/project_api/crud.py
    views/api/project_api/fsm_handbrake.py
    views/api/project_api/schemas.py
    views/api/project_api/settings.py
    views/api/scenario_api/__init__.py
    views/api/scenario_api/api.py
    views/api/scenario_api/hosts_transfer_scenario.py
    views/api/scenario_api/noc_scenario.py
    views/api/scenario_api/full_process_scenario.py
    views/api/scenario_api/operations.py
    views/api/scenario_api/scenario_postprocessor.py
    views/api/settings_api.py
    views/api/third_party_api.py
    views/api/token_api.py
    views/api/tickets_api.py
    views/api/user_api.py
    views/cms/__init__.py
    views/cms/cms_api.py
    views/helpers/__init__.py
    views/helpers/constants.py
    views/helpers/hosts.py
    views/helpers/maintenance.py
    views/helpers/validators.py
    views/metrics/__init__.py
    views/metrics/metrics_api.py
    views/profiler/__init__.py
    views/profiler/profiler_api.py
    yc/__init__.py
    yc/types.py
)

RESOURCE_FILES(
    templates/scenario/itdc_maintenance/ok_host_group_approve_request.txt
    templates/scenario/itdc_maintenance/startrek_approvement_text.txt
    templates/scenario/itdc_maintenance/startrek_start_scenario.txt
    templates/scenario/itdc_maintenance/startrek_end_scenario.txt
    templates/scenario/itdc_maintenance/startrek_host_group_received_approve.txt
    templates/scenario/itdc_maintenance/startrek_host_group_approve_escalation.txt
    templates/scenario/itdc_maintenance/startrek_host_group_approve_declined.txt
    templates/scenario/itdc_maintenance/startrek_host_ready_for_work.txt
    templates/scenario/itdc_maintenance/startrek_host_revival.txt
    templates/scenario/noc_hard/ok_host_group_approve_request.txt
    templates/scenario/noc_hard/startrek_approvement_text.txt
    templates/scenario/noc_hard/startrek_start_scenario.txt
    templates/scenario/noc_hard/startrek_end_scenario.txt
    templates/scenario/noc_hard/startrek_host_group_received_approve.txt
    templates/scenario/noc_hard/startrek_host_group_approve_declined.txt
    templates/scenario/noc_hard/startrek_host_ready_for_work.txt
    templates/scenario/noc_hard/startrek_host_revival.txt
    templates/scenario/common/ok_host_group_approve_request.txt
    templates/scenario/common/startrek_approvement_text.txt
    templates/scenario/common/startrek_host_group_approve_declined.txt
    templates/scenario/common/startrek_host_group_received_approve.txt
    templates/scenario/check_and_report_about_host_restrictions_stage.txt
    templates/scenario/dump_approvers_list.txt
    templates/scenario/ok_approve_message_hosts_init.txt
    templates/scenario/startrek_approve_body.txt
    templates/scenario/startrek_approve_canceled.txt
    templates/scenario/startrek_approve_hosts_diff.txt
    templates/scenario/startrek_dns_request.txt
    templates/scenario/startrek_storage_info.txt
    templates/scenario/startrek_emergency_message.txt
    templates/scenario/startrek_end_scenario_hosts_init.txt
    templates/scenario/startrek_start_scenario_hosts_init.txt
    templates/scenario/startrek_scenario_cancelled.txt
    templates/scenario/startrek_get_responsibles_to_ticket.txt
    templates/custom_ticket_description.txt
    templates/index.html
    templates/noc_request_ticket_description.txt
    templates/test.html
    static/favicon.ico
    static/jquery/images/ui-bg_flat_0_aaaaaa_40x100.png
    static/jquery/images/ui-bg_flat_75_ffffff_40x100.png
    static/jquery/images/ui-bg_glass_55_fbf9ee_1x400.png
    static/jquery/images/ui-bg_glass_65_ffffff_1x400.png
    static/jquery/images/ui-bg_glass_75_dadada_1x400.png
    static/jquery/images/ui-bg_glass_75_e6e6e6_1x400.png
    static/jquery/images/ui-bg_glass_95_fef1ec_1x400.png
    static/jquery/images/ui-bg_highlight-soft_75_cccccc_1x100.png
    static/jquery/images/ui-icons_222222_256x240.png
    static/jquery/images/ui-icons_2e83ff_256x240.png
    static/jquery/images/ui-icons_454545_256x240.png
    static/jquery/images/ui-icons_888888_256x240.png
    static/jquery/images/ui-icons_cd0a0a_256x240.png
    static/jquery/jquery-ui.min.css
    static/jquery/jquery-ui.min.js
    static/jquery/jquery-ui.theme.min.css
    static/jquery/jquery.min.js
    static/prettify.css
    static/prettify.js
    static/style.css
    static/walle.jpg
    walle.conf.yaml
)

PEERDIR(
    cloud/iam/accessservice/client/python
    cloud/bitbucket/private-api/yandex/cloud/priv/iam/v1
    contrib/python/APScheduler
    contrib/python/attrs
    contrib/python/cachetools
    contrib/python/contextlib2
    contrib/python/dateutil
    contrib/python/dnspython
    contrib/python/fastjsonschema
    contrib/python/Flask
    contrib/python/flask-cors
    contrib/python/gevent
    contrib/python/greenlet
    contrib/python/humanize
    contrib/python/ipython
    contrib/python/mongoengine
    contrib/python/natsort
    contrib/python/paramiko
    contrib/python/py-radix
    contrib/python/pygtrie
    contrib/python/pymongo
    contrib/python/pyOpenSSL
    contrib/python/PyYAML
    contrib/python/raven
    contrib/python/requests
    contrib/python/sentry-sdk
    contrib/python/simplejson
    contrib/python/six
    contrib/python/tzlocal
    contrib/python/uhashring
    contrib/python/Werkzeug
    contrib/python/xxhash
    contrib/python/yappi
    juggler/sdk/juggler_sdk
    infra/walle/server/contrib/object-validator
    infra/walle/server/contrib/sepelib/core
    infra/walle/server/contrib/sepelib/flask
    infra/walle/server/contrib/sepelib/mongo
    infra/walle/server/contrib/sepelib/util
    infra/walle/server/contrib/sepelib/yandex
    infra/walle/server/contrib/sepelib/util
    infra/walle/server/contrib/yc_python_sdk/yandexcloud
    infra/walle/server/proto
    infra/wall-e/sdk
    kikimr/public/sdk/python/persqueue
    library/python/blackbox
    library/python/errorboosterclient
    library/python/resource
    library/python/deprecated/ticket_parser2
)

NO_CHECK_IMPORTS(
    walle.views.*
    walle.project_builder
)

END()
