import dataclasses
import enum


class DnsApiType(str, enum.Enum):
    slayer_dns = "slayer_dns"
    rurikk_dns = "rurikk_dns"


@dataclasses.dataclass
class YcDnsZone:
    id: str
    zone: str
    folder_id: str

    def get_host_suffix(self):
        return self.zone[:-1]
