const CircularDependencyPlugin = require('circular-dependency-plugin');
const TsconfigPathsPlugin = require('tsconfig-paths-webpack-plugin');
const path = require('path');

module.exports = {
   addons: [
      // '@storybook/preset-create-react-app', (conflict with decorators)
      '@storybook/addon-actions',
      '@storybook/addon-links',
      '@storybook/addon-knobs',
      '@storybook/addon-options',
   ],
   stories: ['../src/**/*.stories.tsx'],
   webpack: async (config, { configType }) => ({
      ...config,
      module: {
         ...config.module,
         rules: [
            ...config.module.rules,
            {
               test: /\.(scss)$/,
               use: [
                  {
                     loader: 'style-loader',
                  },
                  {
                     loader: 'css-loader',
                  },
                  {
                     loader: require.resolve('sass-loader'),
                  },
               ],
            },
         ],
      },
      plugins: [
         ...config.plugins,
         false || configType === 'DEVELOPMENT'
            ? new CircularDependencyPlugin({
                 // allow import cycles that include an asynchronous import,
                 // e.g. via import(/* webpackMode: "weak" */ './file.js')
                 allowAsyncCycles: false,
                 // set the current working directory for displaying module paths
                 cwd: process.cwd(),
                 // exclude detection of files based on a RegExp
                 exclude: /node_modules/,
                 // add errors to webpack instead of warnings
                 failOnError: false,
              })
            : undefined,
      ].filter(p => p),
      resolve: {
         ...config.resolve,
         plugins: [
            ...config.resolve.plugins,
            new TsconfigPathsPlugin({
               configFile: path.resolve(__dirname, '../tsconfig.json'),
            }),
         ],
         // Обход проблемы импорта в Lego-on-react
         mainFields: ['browser', 'module', 'main'],
      },
   }),
};
