context('ChangeStatusHostAction', () => {
   const $btnChangeStatus = 'span[data-e2e="ActionButtons:menu:force-status"]';
   const $inputTicketKey = 'input[name="ticket_key"]'
   const $textareaReason = 'textarea[name="reason"]'

   const $btnRunAction = 'button[data-e2e="Modal:ok"]';

   const testStr = 'test';

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check Release button', () => {
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.intercept('GET', /\/v1\/hosts\/([\w\d.-]+?)/, {
         fixture: 'project',
      }).as('project');

      cy.visit('/host/sandbox-preprod24.search.yandex.net');

      cy.mockSwitcher();

      cy.get('button[data-e2e="ActionButtons:more"]').click();
      cy.get($btnChangeStatus).should(el => {
         expect(el).to.contain('Change status (deprecated)');
      });
   });

   it('Should show modal', () => {
      cy.get($btnChangeStatus).click();
      cy.get('.modal__content').should('exist');
   });

   it('Check request', () => {
      cy.intercept('POST', /\/hosts\/[\da-f]+\/force-status$/, req => {
         if (req.body) {
            expect(req.body).to.deep.equal({ 'reason': testStr, 'status': 'manual', 'ticket_key': testStr });
         }
      }).as('changeStatus');

      cy.get($inputTicketKey).type(testStr)
      cy.get($textareaReason).type(testStr)

      cy.get($btnRunAction).click();

      cy.wait('@changeStatus');
   });
});
