context('ProfileHostAction', () => {
   const $actionBtn = 'button[name="profile"]';
   const $btnRunAction = 'button[data-e2e="Modal:ok"]';

   const $typeSelect = '.yc-select-control__tokens-text';
   const $typeSelectItem = 'div[data-value="medium"]';

   beforeEach(() => {
      cy.loginRobot();
      cy.baseIntercept();

      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects',
      }).as('projects');
      cy.intercept('GET', /\/v1\/hosts\/([\w\d.-]+?)/, {
         fixture: 'project',
      }).as('project');

      cy.visit('/host/sandbox-preprod24.search.yandex.net');

      cy.mockSwitcher();
   });

   it('Without Advanced Options', () => {
      cy.intercept('POST', /\/hosts\/[\da-f]+\/profile$/, req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               check: true,
               disable_admin_requests: false,
               profile_mode: 'default',
               redeploy: false,
               with_auto_healing: true,
            });
         }
      }).as('profile');

      cy.get($actionBtn).click();

      cy.get($btnRunAction).click();

      cy.wait('@profile');
   });

   it('With only ignore_cms = false', () => {
      cy.intercept('POST', /\/hosts\/[\da-f]+\/profile$/, req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               check: true,
               disable_admin_requests: false,
               profile_mode: 'default',
               redeploy: false,
               with_auto_healing: true,
               ignore_cms: false,
            });
         }
      }).as('profile');

      cy.get($actionBtn).click();

      cy.get('label').contains('Advanced options').click();

      cy.get($btnRunAction).click();

      cy.wait('@profile');
   });

   it('With ignore_cms = false && repair_request_severity = "medium"', () => {
      cy.intercept('POST', /\/hosts\/[\da-f]+\/profile$/, req => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               check: true,
               disable_admin_requests: false,
               profile_mode: 'default',
               redeploy: false,
               with_auto_healing: true,
               ignore_cms: false,
               repair_request_severity: 'medium'
            });
         }
      }).as('profile');

      cy.get($actionBtn).click();

      cy.get('label').contains('Advanced options').click();

      cy.get($typeSelect).contains('—').click();
      cy.get($typeSelectItem).click();

      cy.get($btnRunAction).click();

      cy.wait('@profile');
   });
});
