context('ReleaseHostAction', () => {
   const btnRelease = '.popup2_visible_yes .menu div:nth-child(6)'
   const btnRunAction = 'button[data-e2e="Modal:ok"]'

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check Release button', () => {
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects'
      }).as('projects')
      cy.intercept('GET',  /\/v1\/hosts\/([\w\d.-]+?)/, {
         fixture: 'project'
      }).as('project')

      cy.visit('/host/sandbox-preprod24.search.yandex.net');

      cy.mockSwitcher()

      cy.get('button[data-e2e="ActionButtons:more"]').click()
      cy.get(btnRelease).should((el) => {
         expect(el).to.contain('Release')
      })
   })

   it('Should show modal', () => {
      cy.get(btnRelease).click()
      cy.get('.modal__content').should('exist')
   });

   it('Check request', () => {
      cy.intercept('POST', /\/hosts\/[\da-f]+\/release-host$/, (req) => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               disable_admin_requests: false,
               erase_disks: true,
               ignore_cms: false
            })
         }
      }).as('releaseHost')

      cy.get(btnRunAction).click()

      cy.wait('@releaseHost')
   });
});
