context('FindTicketFieldPopup', () => {
   const $EditProjectButton = '[data-e2e="EditProjectButton"]'
   const $SaveProjectButton = '[data-e2e="SaveProjectButton"]'
   const $SubmitButton = 'button[type="submit"]'
   const $Tumbler = 'div[name="reports"] input[type="checkbox"]'
   const $AddButton = 'button[name="add-field-button"]'

   const $suggestField = '.yc-text-input__control[placeholder="Find system field or add custom"]'

   const testString = 'T'


   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check Suggest input val', () => {
      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn'
      }).as('sandbox-mtn')

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn')

      cy.mockSwitcher()

      cy.get($EditProjectButton).click()

      cy.get($Tumbler).check({force: true})

      cy.get($AddButton).click()

      cy.get($suggestField).type(testString)
      cy.get($suggestField).should((el) => {
         expect(el.val()).include(testString)
      })

   })

   it('Check Suggest modal', () => {
      cy.get('.yc-list__items').should('exist')
   })

   it('Check request', () => {
      cy.intercept('POST', 'v1/projects/sandbox-mtn/reports', (req) => {
         if (req.body) {
            expect(req.body.extra).to.include({
               [testString]: testString
            })
         }
      }).as('updateProject')

      cy.get($suggestField).type('{enter}')

      cy.get(`.textinput__control[name="${testString}"]`).clear()
      cy.get(`.textinput__control[name="${testString}"]`).type(testString)

      cy.get($SaveProjectButton).click()
      cy.get($SubmitButton).click()

      cy.wait('@updateProject')
   });
});
