context('AbcBotInput', () => {
   const $EditProjectButton = '[data-e2e="EditProjectButton"]'
   const $SaveProjectButton = '[data-e2e="SaveProjectButton"]'
   const $SubmitButton = 'button[type="submit"]'

   const $suggestField = 'input[placeholder="ABC service slug"]'
   const $suggestItem = '.yc-suggest__item > div'

   const testString = 'sandbox-ci'

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check Suggest input val', () => {
      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn'
      }).as('sandbox-mtn')
      cy.intercept('GET', /\/v1\/bot-projects$/, {
         fixture: 'bot-projects'
      }).as('bot-projects')

      cy.intercept('GET', /\/external_api\/abc\/services\?([\w\d.-]+?)/, {
         fixture: 'suggestAbcProject'
      }).as('getSuggestions')

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn')
      cy.wait('@bot-projects')

      cy.mockSwitcher()

      cy.get($EditProjectButton).click()

      cy.get($suggestField).clear()
      cy.get($suggestField).type(testString)
      cy.get($suggestField).should((el) => {
         expect(el.val()).include(testString)
      })

   })

   it('Check Suggest modal and item', () => {
      cy.get('.yc-list__items').should('exist')
      cy.get($suggestItem).eq(0).should('exist')
   })

   it('Check request', () => {
      cy.intercept('POST', 'v1/projects/sandbox-mtn/bot_project_id', (req) => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               bot_project_id: 100008645,
               reason: ""
            })
         }
      }).as('updateProject')


      // ругается на overflow: hidden;
      cy.get($suggestItem).contains(testString).click()
      cy.get($SaveProjectButton).click()
      cy.get($SubmitButton).click()

      cy.wait('@updateProject')
   });
});
