context('UserSelect', () => {
   const $EditProjectButton = '[data-e2e="EditProjectButton"]'
   const $SaveProjectButton = '[data-e2e="SaveProjectButton"]'
   const $SubmitButton = 'button[type="submit"]'

   const $suggestField = 'div[name="notifications"] .yc-text-input__control[placeholder="Login or group"]'
   const $suggestItem = '.yc-suggest__item > div'

   const testString = 'robot-infracloudui'


   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check Suggest input val', () => {
      cy.intercept('GET', /\/projects\/sandbox-mtn\?([\w\d.-]+?)/, {
         fixture: 'sandbox-mtn'
      }).as('sandbox-mtn')

      cy.intercept('GET', /suggest/, {
         fixture: 'suggestEmailNotification'
      }).as('getSuggestions')

      cy.visit('/project/sandbox-mtn');

      cy.wait('@sandbox-mtn')

      cy.mockSwitcher()

      cy.get($EditProjectButton).click()

      cy.get($suggestField).eq(0).clear()
      cy.get($suggestField).eq(0).type(testString)
      cy.get($suggestField).eq(0).should((el) => {
         expect(el.val()).include(testString)
      })

      cy.wait('@getSuggestions')
   })

   it('Check Suggest modal', () => {
      cy.get('.yc-list__items').should('exist')
   })

   it('Check request', () => {
      cy.intercept('GET', /persons/, (req) => {
         if (req.body) {
            expect(req.body['emails.address']).include(`${testString}`)
         }
      }).as('updateProject')

      cy.get($suggestItem).contains(testString).click()

      cy.get($SaveProjectButton).click()
      cy.get($SubmitButton).click()

      cy.wait('@updateProject')
   });
});
