context('ProfileConfigInput', () => {
   const $btnProfile = 'button[name="profile"]'
   const $btnRunAction = '.modal .button2_theme_action'

   const $suggestField = '.yc-text-input__control[placeholder="Profile config"]'

   const testString = 'rmt'

   const responsePath = 'v1/deploy-configs'
   const requestPath = /\/hosts\/[\da-f]+\/profile$/


   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check Suggest input val', () => {
      cy.intercept('GET', /\/v1\/projects/, {
         fixture: 'projects'
      }).as('projects')
      cy.intercept('GET',  /\/v1\/hosts\/([\w\d.-]+?)/, {
         fixture: 'project'
      }).as('project')

      cy.intercept('GET', responsePath, {
         fixture: 'suggestProfileConfig'
      }).as('getSuggestions')

      cy.visit('/host/sandbox-preprod24.search.yandex.net');

      cy.mockSwitcher()

      cy.get($btnProfile).click()
      cy.get('input[value="custom"]').click()

      cy.get($suggestField).clear()
      cy.get($suggestField).type(testString)
      cy.get($suggestField).should((el) => {
         expect(el.val()).include(testString)
      })

      cy.wait('@getSuggestions')
   })

   it('Check Suggest modal', () => {
      cy.get('.yc-list__items').should('exist')
   })

   it('Check request', () => {
      cy.intercept('POST', requestPath, (req) => {
         if (req.body) {
            expect(req.body).to.deep.equal({
               check: true,
               disable_admin_requests: false,
               profile: testString,
               redeploy: false,
               with_auto_healing: true,
            })
         }
      }).as('updateProject')

      cy.get($btnRunAction).click()

      cy.wait('@updateProject')
   });
});
