context('TrackerIssueField', () => {
   const $suggestField = '.yc-text-input__control';

   const testString = 'WALLEUI-169';

   before(() => {
      cy.loginRobot();
      cy.baseIntercept();
   });

   it('Check Suggest input val', () => {
      cy.intercept('GET', `https://st-api.yandex-team.ru/v2/issues/_suggest?input=${testString}`, {
         fixture: 'suggestTicket',
      }).as('getSuggestions');

      cy.visit('/scenarios');

      cy.mockSwitcher();

      cy.get('.yc-button__text').contains('Create').click({ force: true });

      cy.get($suggestField).eq(1).type(testString);
      cy.get($suggestField)
         .eq(1)
         .should(el => {
            expect(el.val()).include(testString);
         });

      cy.wait('@getSuggestions');
   });

   it('Check Suggest modal', () => {
      cy.get('.yc-list__items').should('exist');
   });

   it('Check request', () => {
      cy.intercept('POST', 'scenarios', req => {
         if (req.body) {
            console.log(req.body);
            expect(req.body).to.deep.equal({
               name: testString,
               autostart: false,
               scenario_type: 'hosts-transfer',
               script_args: { delete: true },
               ticket_key: testString,
            });
         }
      }).as('createScenario');

      // заполняем required поля формы
      cy.get('input[value="abc"]').click();
      cy.get('input[placeholder="Enter scenario name"]').type(testString);

      cy.get('button[type=submit]').click();

      cy.wait('@createScenario');
   });
});
